/*
 * Copyright 2025 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include <eiq_app.h>
#include "fsl_debug_console.h"
#include "board.h"
#include "app.h"
#include "multicore_coms.h"

#include "FreeRTOS.h"
#include "task.h"
#include "queue.h"
/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*******************************************************************************
 * Prototypes
 ******************************************************************************/

/*******************************************************************************
 * Code
 ******************************************************************************/

static void eIQApp_Task(void *param)
{
	MCC_Init();
	eIQApp_Init();

	while(1)
	{
		eIQApp_Inference_Loop();
	}
}

int main(void) {
	BOARD_InitHardware();

    if (xTaskCreate(eIQApp_Task, "eiq app task", 2500L / sizeof(portSTACK_TYPE), NULL, 4, NULL) != pdPASS)
    {
        PRINTF("Error creating task\r\n");
        while(1);
    }

    vTaskStartScheduler();
    while (1)
    {
        ;
    }
}
