/*
 * Copyright 2025 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef MODEL_CONFIG_H_
#define MODEL_CONFIG_H_

#define MODEL_WIDTH 		320
#define MODEL_HEIGHT 		320
#define MODEL_CHANNELS      3
#define MODEL_INPUT_SIZE    (MODEL_WIDTH * MODEL_HEIGHT * MODEL_CHANNELS)

#define GRID_HEIGHT 		20 // Number of vertical cells in the output grid of Persondetect
#define GRID_WIDTH 			20 // Number of horizontal cells in the output grid of Persondetect

// Constants for data normalization/scaling
#define MODEL_NAME          "fastestdet_full_quant_npu.h"
#define MODEL_INPUT_MEAN    (255.0f * 0.01865844801068306f)
#define MODEL_INPUT_STD     14.0f
#define OUTPUT_ZERO_POINT   -20.0f
#define OUTPUT_SCALE 	    0.04461762681603432f
#define CANAL 				6 /* box data : Score,x, y, width, height, class  */
#define MAX_BOXES 			(GRID_HEIGHT * GRID_WIDTH)
#define NMS_THRESHOLD 		0.45f
#define SCORE_THRESHOLD 	63.0f

#endif /* MODEL_CONFIG_H_ */
