/*
** ###################################################################
**     Processors:          MIMXRT735SGAWAR_cm33_core0
**                          MIMXRT735SGAWAR_cm33_core1
**                          MIMXRT735SGAWAR_ezhv
**                          MIMXRT735SGAWAR_hifi1
**                          MIMXRT735SGFOA_cm33_core0
**                          MIMXRT735SGFOA_cm33_core1
**                          MIMXRT735SGFOA_ezhv
**                          MIMXRT735SGFOA_hifi1
**                          MIMXRT758SGAWAR_cm33_core0
**                          MIMXRT758SGAWAR_cm33_core1
**                          MIMXRT758SGAWAR_ezhv
**                          MIMXRT758SGAWAR_hifi1
**                          MIMXRT758SGFOA_cm33_core0
**                          MIMXRT758SGFOA_cm33_core1
**                          MIMXRT758SGFOA_ezhv
**                          MIMXRT758SGFOA_hifi1
**                          MIMXRT798SGAWAR_cm33_core0
**                          MIMXRT798SGAWAR_cm33_core1
**                          MIMXRT798SGAWAR_ezhv
**                          MIMXRT798SGAWAR_hifi1
**                          MIMXRT798SGAWAR_hifi4
**                          MIMXRT798SGFOA_cm33_core0
**                          MIMXRT798SGFOA_cm33_core1
**                          MIMXRT798SGFOA_ezhv
**                          MIMXRT798SGFOA_hifi1
**                          MIMXRT798SGFOA_hifi4
**
**     Version:             rev. 2.0, 2024-05-28
**     Build:               b241121
**
**     Abstract:
**         CMSIS Peripheral Access Layer for OCOTP
**
**     Copyright 1997-2016 Freescale Semiconductor, Inc.
**     Copyright 2016-2024 NXP
**     SPDX-License-Identifier: BSD-3-Clause
**
**     http:                 www.nxp.com
**     mail:                 support@nxp.com
**
**     Revisions:
**     - rev. 1.0 (2022-09-15)
**         Initial version.
**     - rev. 2.0 (2024-05-28)
**         Rev2 DraftA.
**
** ###################################################################
*/

/*!
 * @file OCOTP.h
 * @version 2.0
 * @date 2024-05-28
 * @brief CMSIS Peripheral Access Layer for OCOTP
 *
 * CMSIS Peripheral Access Layer for OCOTP
 */

#if !defined(OCOTP_H_)
#define OCOTP_H_                                 /**< Symbol preventing repeated inclusion */

#if (defined(CPU_MIMXRT735SGAWAR_cm33_core0) || defined(CPU_MIMXRT735SGFOA_cm33_core0))
#include "MIMXRT735S_cm33_core0_COMMON.h"
#elif (defined(CPU_MIMXRT735SGAWAR_cm33_core1) || defined(CPU_MIMXRT735SGFOA_cm33_core1))
#include "MIMXRT735S_cm33_core1_COMMON.h"
#elif (defined(CPU_MIMXRT735SGAWAR_ezhv) || defined(CPU_MIMXRT735SGFOA_ezhv))
#include "MIMXRT735S_ezhv_COMMON.h"
#elif (defined(CPU_MIMXRT735SGAWAR_hifi1) || defined(CPU_MIMXRT735SGFOA_hifi1))
#include "MIMXRT735S_hifi1_COMMON.h"
#elif (defined(CPU_MIMXRT758SGAWAR_cm33_core0) || defined(CPU_MIMXRT758SGFOA_cm33_core0))
#include "MIMXRT758S_cm33_core0_COMMON.h"
#elif (defined(CPU_MIMXRT758SGAWAR_cm33_core1) || defined(CPU_MIMXRT758SGFOA_cm33_core1))
#include "MIMXRT758S_cm33_core1_COMMON.h"
#elif (defined(CPU_MIMXRT758SGAWAR_ezhv) || defined(CPU_MIMXRT758SGFOA_ezhv))
#include "MIMXRT758S_ezhv_COMMON.h"
#elif (defined(CPU_MIMXRT758SGAWAR_hifi1) || defined(CPU_MIMXRT758SGFOA_hifi1))
#include "MIMXRT758S_hifi1_COMMON.h"
#elif (defined(CPU_MIMXRT798SGAWAR_cm33_core0) || defined(CPU_MIMXRT798SGFOA_cm33_core0))
#include "MIMXRT798S_cm33_core0_COMMON.h"
#elif (defined(CPU_MIMXRT798SGAWAR_cm33_core1) || defined(CPU_MIMXRT798SGFOA_cm33_core1))
#include "MIMXRT798S_cm33_core1_COMMON.h"
#elif (defined(CPU_MIMXRT798SGAWAR_ezhv) || defined(CPU_MIMXRT798SGFOA_ezhv))
#include "MIMXRT798S_ezhv_COMMON.h"
#elif (defined(CPU_MIMXRT798SGAWAR_hifi1) || defined(CPU_MIMXRT798SGFOA_hifi1))
#include "MIMXRT798S_hifi1_COMMON.h"
#elif (defined(CPU_MIMXRT798SGAWAR_hifi4) || defined(CPU_MIMXRT798SGFOA_hifi4))
#include "MIMXRT798S_hifi4_COMMON.h"
#else
  #error "No valid CPU defined!"
#endif

/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic push
  #else
    #pragma push
    #pragma anon_unions
  #endif
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#elif defined(__XTENSA__)
  /* anonymous unions are enabled by default */
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- OCOTP Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup OCOTP_Peripheral_Access_Layer OCOTP Peripheral Access Layer
 * @{
 */

/** OCOTP - Size of Registers Arrays */
#define OCOTP_OTP_SHADOW_PARTA_COUNT              48u
#define OCOTP_OTP_SHADOW_PARTB_COUNT              368u

/** OCOTP - Register Layout Typedef */
typedef struct {
  __IO uint32_t OTP_SHADOW_PARTA[OCOTP_OTP_SHADOW_PARTA_COUNT]; /**< OTP shadow register, array offset: 0x0, array step: 0x4 */
       uint8_t RESERVED_0[384];
  __IO uint32_t OTP_SHADOW_PARTB[OCOTP_OTP_SHADOW_PARTB_COUNT]; /**< OTP shadow register, array offset: 0x240, array step: 0x4 */
  __IO uint32_t CTRL;                              /**< OTP Controller Control Register, offset: 0x800 */
       uint8_t RESERVED_1[4];
  __IO uint32_t HW_OCOTP_WRITE_DATA;               /**< OTP Controller Write Data Register, offset: 0x808 */
  __IO uint32_t READ_CTRL;                         /**< OTP Controller Read Ctrl Register, offset: 0x80C */
  __IO uint32_t HW_OCOTP_READ_DATA;                /**< OTP Controller Read Data Register, offset: 0x810 */
       uint8_t RESERVED_2[12];
  __IO uint32_t HW_OCOTP_STATUS;                   /**< OTP Controller Status Register, offset: 0x820 */
       uint8_t RESERVED_3[4];
  __I  uint32_t VERSION;                           /**< OTP Controller Version Register, offset: 0x828 */
  __IO uint32_t HW_OCOTP_NONMASK_STATUS1;          /**< OTP Controller Nonmask Status1 Register, offset: 0x82C */
  __IO uint32_t HW_OCOTP_MASK_CTRL1;               /**< OTP Controller Mask Ctrl1 Register, offset: 0x830 */
  __IO uint32_t HW_OCOTP_MASK_STATUS1;             /**< OTP Controller Nonmask Status1 Register, offset: 0x834 */
       uint8_t RESERVED_4[68];
  __IO uint32_t HW_OCOTP_LOCK_STICKY_0;            /**< OTP Controller Lock Sticky Register0, offset: 0x87C */
  __IO uint32_t HW_OCOTP_LOCK_STICKY_1;            /**< OTP Controller Lock Sticky Register1, offset: 0x880 */
  __IO uint32_t HW_OCOTP_LOCK_STICKY_2;            /**< OTP Controller Lock Sticky Register2, offset: 0x884 */
  __IO uint32_t HW_OCOTP_LOCK_STICKY_3;            /**< OTP Controller Lock Sticky Register3, offset: 0x888 */
  __IO uint32_t HW_OCOTP_LOCK_STICKY_4;            /**< OTP Controller Lock Sticky Register4, offset: 0x88C */
  __IO uint32_t HW_OCOTP_LOCK_STICKY_5;            /**< OTP Controller Lock Sticky Register5, offset: 0x890 */
} OCOTP_Type;

/* ----------------------------------------------------------------------------
   -- OCOTP Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup OCOTP_Register_Masks OCOTP Register Masks
 * @{
 */

/*! @name OTP_SHADOW_PARTA - OTP shadow register */
/*! @{ */

#define OCOTP_OTP_SHADOW_PARTA_SHADOW_MASK       (0xFFFFFFFFU)
#define OCOTP_OTP_SHADOW_PARTA_SHADOW_SHIFT      (0U)
/*! SHADOW - OTP shadow register, fsb have read access of shadow 0-47 (offset should be 0*4-47*4) */
#define OCOTP_OTP_SHADOW_PARTA_SHADOW(x)         (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_SHADOW_PARTA_SHADOW_SHIFT)) & OCOTP_OTP_SHADOW_PARTA_SHADOW_MASK)
/*! @} */

/*! @name OTP_SHADOW_PARTB - OTP shadow register */
/*! @{ */

#define OCOTP_OTP_SHADOW_PARTB_SHADOW_MASK       (0xFFFFFFFFU)
#define OCOTP_OTP_SHADOW_PARTB_SHADOW_SHIFT      (0U)
/*! SHADOW - OTP shadow register, fsb have read access of shadow 144-511 (offset should be 144*4-511*4) */
#define OCOTP_OTP_SHADOW_PARTB_SHADOW(x)         (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_SHADOW_PARTB_SHADOW_SHIFT)) & OCOTP_OTP_SHADOW_PARTB_SHADOW_MASK)
/*! @} */

/*! @name CTRL - OTP Controller Control Register */
/*! @{ */

#define OCOTP_CTRL_ADDR_MASK                     (0x1FFU)
#define OCOTP_CTRL_ADDR_SHIFT                    (0U)
#define OCOTP_CTRL_ADDR(x)                       (((uint32_t)(((uint32_t)(x)) << OCOTP_CTRL_ADDR_SHIFT)) & OCOTP_CTRL_ADDR_MASK)

#define OCOTP_CTRL_PRNG_OUTPUT_DATA_EN_MASK      (0x200U)
#define OCOTP_CTRL_PRNG_OUTPUT_DATA_EN_SHIFT     (9U)
#define OCOTP_CTRL_PRNG_OUTPUT_DATA_EN(x)        (((uint32_t)(((uint32_t)(x)) << OCOTP_CTRL_PRNG_OUTPUT_DATA_EN_SHIFT)) & OCOTP_CTRL_PRNG_OUTPUT_DATA_EN_MASK)

#define OCOTP_CTRL_SRAM_ENTROPY_DATA_EN_MASK     (0x400U)
#define OCOTP_CTRL_SRAM_ENTROPY_DATA_EN_SHIFT    (10U)
#define OCOTP_CTRL_SRAM_ENTROPY_DATA_EN(x)       (((uint32_t)(((uint32_t)(x)) << OCOTP_CTRL_SRAM_ENTROPY_DATA_EN_SHIFT)) & OCOTP_CTRL_SRAM_ENTROPY_DATA_EN_MASK)

#define OCOTP_CTRL_RELOAD_SHADOWS_MASK           (0x800U)
#define OCOTP_CTRL_RELOAD_SHADOWS_SHIFT          (11U)
#define OCOTP_CTRL_RELOAD_SHADOWS(x)             (((uint32_t)(((uint32_t)(x)) << OCOTP_CTRL_RELOAD_SHADOWS_SHIFT)) & OCOTP_CTRL_RELOAD_SHADOWS_MASK)

#define OCOTP_CTRL_RED_MUX_SEL_MASK              (0x3000U)
#define OCOTP_CTRL_RED_MUX_SEL_SHIFT             (12U)
#define OCOTP_CTRL_RED_MUX_SEL(x)                (((uint32_t)(((uint32_t)(x)) << OCOTP_CTRL_RED_MUX_SEL_SHIFT)) & OCOTP_CTRL_RED_MUX_SEL_MASK)

#define OCOTP_CTRL_SUPPADD_MASK                  (0x4000U)
#define OCOTP_CTRL_SUPPADD_SHIFT                 (14U)
#define OCOTP_CTRL_SUPPADD(x)                    (((uint32_t)(((uint32_t)(x)) << OCOTP_CTRL_SUPPADD_SHIFT)) & OCOTP_CTRL_SUPPADD_MASK)

#define OCOTP_CTRL_WORDLOCK_MASK                 (0x8000U)
#define OCOTP_CTRL_WORDLOCK_SHIFT                (15U)
#define OCOTP_CTRL_WORDLOCK(x)                   (((uint32_t)(((uint32_t)(x)) << OCOTP_CTRL_WORDLOCK_SHIFT)) & OCOTP_CTRL_WORDLOCK_MASK)

#define OCOTP_CTRL_WR_UNLOCK_MASK                (0xFFFF0000U)
#define OCOTP_CTRL_WR_UNLOCK_SHIFT               (16U)
#define OCOTP_CTRL_WR_UNLOCK(x)                  (((uint32_t)(((uint32_t)(x)) << OCOTP_CTRL_WR_UNLOCK_SHIFT)) & OCOTP_CTRL_WR_UNLOCK_MASK)
/*! @} */

/*! @name HW_OCOTP_WRITE_DATA - OTP Controller Write Data Register */
/*! @{ */

#define OCOTP_HW_OCOTP_WRITE_DATA_WRITE_DATA_MASK (0xFFFFFFFFU)
#define OCOTP_HW_OCOTP_WRITE_DATA_WRITE_DATA_SHIFT (0U)
#define OCOTP_HW_OCOTP_WRITE_DATA_WRITE_DATA(x)  (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_WRITE_DATA_WRITE_DATA_SHIFT)) & OCOTP_HW_OCOTP_WRITE_DATA_WRITE_DATA_MASK)
/*! @} */

/*! @name READ_CTRL - OTP Controller Read Ctrl Register */
/*! @{ */

#define OCOTP_READ_CTRL_READ_MASK                (0x1U)
#define OCOTP_READ_CTRL_READ_SHIFT               (0U)
#define OCOTP_READ_CTRL_READ(x)                  (((uint32_t)(((uint32_t)(x)) << OCOTP_READ_CTRL_READ_SHIFT)) & OCOTP_READ_CTRL_READ_MASK)
/*! @} */

/*! @name HW_OCOTP_READ_DATA - OTP Controller Read Data Register */
/*! @{ */

#define OCOTP_HW_OCOTP_READ_DATA_READ_DATA_MASK  (0xFFFFFFFFU)
#define OCOTP_HW_OCOTP_READ_DATA_READ_DATA_SHIFT (0U)
#define OCOTP_HW_OCOTP_READ_DATA_READ_DATA(x)    (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_READ_DATA_READ_DATA_SHIFT)) & OCOTP_HW_OCOTP_READ_DATA_READ_DATA_MASK)
/*! @} */

/*! @name HW_OCOTP_STATUS - OTP Controller Status Register */
/*! @{ */

#define OCOTP_HW_OCOTP_STATUS_LOAD_COUNTER_MASK  (0x1FFU)
#define OCOTP_HW_OCOTP_STATUS_LOAD_COUNTER_SHIFT (0U)
#define OCOTP_HW_OCOTP_STATUS_LOAD_COUNTER(x)    (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_STATUS_LOAD_COUNTER_SHIFT)) & OCOTP_HW_OCOTP_STATUS_LOAD_COUNTER_MASK)

#define OCOTP_HW_OCOTP_STATUS_LC_NOT_BLANK_STICKY_MASK (0x200U)
#define OCOTP_HW_OCOTP_STATUS_LC_NOT_BLANK_STICKY_SHIFT (9U)
#define OCOTP_HW_OCOTP_STATUS_LC_NOT_BLANK_STICKY(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_STATUS_LC_NOT_BLANK_STICKY_SHIFT)) & OCOTP_HW_OCOTP_STATUS_LC_NOT_BLANK_STICKY_MASK)

#define OCOTP_HW_OCOTP_STATUS_LOCKED_MASK        (0x800U)
#define OCOTP_HW_OCOTP_STATUS_LOCKED_SHIFT       (11U)
#define OCOTP_HW_OCOTP_STATUS_LOCKED(x)          (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_STATUS_LOCKED_SHIFT)) & OCOTP_HW_OCOTP_STATUS_LOCKED_MASK)

#define OCOTP_HW_OCOTP_STATUS_PROGFAIL_MASK      (0x1000U)
#define OCOTP_HW_OCOTP_STATUS_PROGFAIL_SHIFT     (12U)
#define OCOTP_HW_OCOTP_STATUS_PROGFAIL(x)        (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_STATUS_PROGFAIL_SHIFT)) & OCOTP_HW_OCOTP_STATUS_PROGFAIL_MASK)

#define OCOTP_HW_OCOTP_STATUS_ACK_MASK           (0x2000U)
#define OCOTP_HW_OCOTP_STATUS_ACK_SHIFT          (13U)
#define OCOTP_HW_OCOTP_STATUS_ACK(x)             (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_STATUS_ACK_SHIFT)) & OCOTP_HW_OCOTP_STATUS_ACK_MASK)

#define OCOTP_HW_OCOTP_STATUS_PWOK_MASK          (0x4000U)
#define OCOTP_HW_OCOTP_STATUS_PWOK_SHIFT         (14U)
#define OCOTP_HW_OCOTP_STATUS_PWOK(x)            (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_STATUS_PWOK_SHIFT)) & OCOTP_HW_OCOTP_STATUS_PWOK_MASK)

#define OCOTP_HW_OCOTP_STATUS_PWOKFAIL_MASK      (0x8000U)
#define OCOTP_HW_OCOTP_STATUS_PWOKFAIL_SHIFT     (15U)
#define OCOTP_HW_OCOTP_STATUS_PWOKFAIL(x)        (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_STATUS_PWOKFAIL_SHIFT)) & OCOTP_HW_OCOTP_STATUS_PWOKFAIL_MASK)

#define OCOTP_HW_OCOTP_STATUS_FLAGSTATE_MASK     (0xF0000U)
#define OCOTP_HW_OCOTP_STATUS_FLAGSTATE_SHIFT    (16U)
#define OCOTP_HW_OCOTP_STATUS_FLAGSTATE(x)       (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_STATUS_FLAGSTATE_SHIFT)) & OCOTP_HW_OCOTP_STATUS_FLAGSTATE_MASK)

#define OCOTP_HW_OCOTP_STATUS_BUSY_MASK          (0x400000U)
#define OCOTP_HW_OCOTP_STATUS_BUSY_SHIFT         (22U)
#define OCOTP_HW_OCOTP_STATUS_BUSY(x)            (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_STATUS_BUSY_SHIFT)) & OCOTP_HW_OCOTP_STATUS_BUSY_MASK)

#define OCOTP_HW_OCOTP_STATUS_FUSE_LATCHED_MASK  (0x2000000U)
#define OCOTP_HW_OCOTP_STATUS_FUSE_LATCHED_SHIFT (25U)
#define OCOTP_HW_OCOTP_STATUS_FUSE_LATCHED(x)    (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_STATUS_FUSE_LATCHED_SHIFT)) & OCOTP_HW_OCOTP_STATUS_FUSE_LATCHED_MASK)

#define OCOTP_HW_OCOTP_STATUS_CALIBRATED_MASK    (0x4000000U)
#define OCOTP_HW_OCOTP_STATUS_CALIBRATED_SHIFT   (26U)
#define OCOTP_HW_OCOTP_STATUS_CALIBRATED(x)      (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_STATUS_CALIBRATED_SHIFT)) & OCOTP_HW_OCOTP_STATUS_CALIBRATED_MASK)
/*! @} */

/*! @name VERSION - OTP Controller Version Register */
/*! @{ */

#define OCOTP_VERSION_STEP_VER_MASK              (0xFFFFU)
#define OCOTP_VERSION_STEP_VER_SHIFT             (0U)
#define OCOTP_VERSION_STEP_VER(x)                (((uint32_t)(((uint32_t)(x)) << OCOTP_VERSION_STEP_VER_SHIFT)) & OCOTP_VERSION_STEP_VER_MASK)

#define OCOTP_VERSION_MINOR_VER_MASK             (0xFF0000U)
#define OCOTP_VERSION_MINOR_VER_SHIFT            (16U)
#define OCOTP_VERSION_MINOR_VER(x)               (((uint32_t)(((uint32_t)(x)) << OCOTP_VERSION_MINOR_VER_SHIFT)) & OCOTP_VERSION_MINOR_VER_MASK)

#define OCOTP_VERSION_MAJOR_VER_MASK             (0xFF000000U)
#define OCOTP_VERSION_MAJOR_VER_SHIFT            (24U)
#define OCOTP_VERSION_MAJOR_VER(x)               (((uint32_t)(((uint32_t)(x)) << OCOTP_VERSION_MAJOR_VER_SHIFT)) & OCOTP_VERSION_MAJOR_VER_MASK)
/*! @} */

/*! @name HW_OCOTP_NONMASK_STATUS1 - OTP Controller Nonmask Status1 Register */
/*! @{ */

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_PBRICK_ERR_MASK (0x20U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_PBRICK_ERR_SHIFT (5U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_PBRICK_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_PBRICK_ERR_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_PBRICK_ERR_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_OTP_STATE_ERR_MASK (0x40U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_OTP_STATE_ERR_SHIFT (6U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_OTP_STATE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_OTP_STATE_ERR_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_OTP_STATE_ERR_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_DED_RELOAD_MASK (0x80U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_DED_RELOAD_SHIFT (7U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_DED_RELOAD(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_DED_RELOAD_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_DED_RELOAD_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_DED_MASK (0x100U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_DED_SHIFT (8U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_DED(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_DED_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_DED_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SEC_RELOAD_MASK (0x200U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SEC_RELOAD_SHIFT (9U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SEC_RELOAD(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SEC_RELOAD_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SEC_RELOAD_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SEC_MASK (0x400U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SEC_SHIFT (10U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SEC(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SEC_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SEC_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_CRC_DONE_MASK (0x800U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_CRC_DONE_SHIFT (11U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_CRC_DONE(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_CRC_DONE_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_CRC_DONE_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_CRC_LUT_SEL_ERR_MASK (0x1000U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_CRC_LUT_SEL_ERR_SHIFT (12U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_CRC_LUT_SEL_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_CRC_LUT_SEL_ERR_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_CRC_LUT_SEL_ERR_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_CRC_ADDRESS_RANGE_ERR_MASK (0x2000U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_CRC_ADDRESS_RANGE_ERR_SHIFT (13U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_CRC_ADDRESS_RANGE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_CRC_ADDRESS_RANGE_ERR_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_CRC_ADDRESS_RANGE_ERR_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_CRC_WRITE_PROTECT_ERR_MASK (0x4000U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_CRC_WRITE_PROTECT_ERR_SHIFT (14U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_CRC_WRITE_PROTECT_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_CRC_WRITE_PROTECT_ERR_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_CRC_WRITE_PROTECT_ERR_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_CRC_SECURTY_PROTECT_ERR_MASK (0x8000U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_CRC_SECURTY_PROTECT_ERR_SHIFT (15U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_CRC_SECURTY_PROTECT_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_CRC_SECURTY_PROTECT_ERR_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_CRC_SECURTY_PROTECT_ERR_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_WRITE_ERR_MASK (0x10000U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_WRITE_ERR_SHIFT (16U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_WRITE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_WRITE_ERR_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_WRITE_ERR_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_LOAD_ERR_MASK (0x20000U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_LOAD_ERR_SHIFT (17U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_LOAD_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_LOAD_ERR_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_LOAD_ERR_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_COUNTER_ERR_MASK (0x40000U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_COUNTER_ERR_SHIFT (18U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_COUNTER_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_COUNTER_ERR_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_COUNTER_ERR_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_BITPROTECT_ERR_MASK (0x80000U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_BITPROTECT_ERR_SHIFT (19U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_BITPROTECT_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_BITPROTECT_ERR_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_BITPROTECT_ERR_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_PRNG_O_FAULT_MASK (0x100000U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_PRNG_O_FAULT_SHIFT (20U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_PRNG_O_FAULT(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_PRNG_O_FAULT_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_PRNG_O_FAULT_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_ECC_ZEROIZED_ERR_MASK (0x200000U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_ECC_ZEROIZED_ERR_SHIFT (21U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_ECC_ZEROIZED_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_ECC_ZEROIZED_ERR_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_ECC_ZEROIZED_ERR_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_FUSE_ACCESS_ERR_MASK (0x400000U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_FUSE_ACCESS_ERR_SHIFT (22U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_FUSE_ACCESS_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_FUSE_ACCESS_ERR_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_FUSE_ACCESS_ERR_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_RELOAD_REQ_ERR_MASK (0x800000U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_RELOAD_REQ_ERR_SHIFT (23U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_RELOAD_REQ_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_RELOAD_REQ_ERR_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_RELOAD_REQ_ERR_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_WRITE_DURING_RELOAD_ERR_MASK (0x1000000U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_WRITE_DURING_RELOAD_ERR_SHIFT (24U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_WRITE_DURING_RELOAD_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_WRITE_DURING_RELOAD_ERR_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_WRITE_DURING_RELOAD_ERR_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SHADOW_HVF_READ_ERR_MASK (0x2000000U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SHADOW_HVF_READ_ERR_SHIFT (25U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SHADOW_HVF_READ_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SHADOW_HVF_READ_ERR_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SHADOW_HVF_READ_ERR_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SHADOW_HVF_WRITE_ERR_MASK (0x4000000U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SHADOW_HVF_WRITE_ERR_SHIFT (26U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SHADOW_HVF_WRITE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SHADOW_HVF_WRITE_ERR_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SHADOW_HVF_WRITE_ERR_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SHADOW_SRAM_READ_ERR_MASK (0x8000000U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SHADOW_SRAM_READ_ERR_SHIFT (27U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SHADOW_SRAM_READ_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SHADOW_SRAM_READ_ERR_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SHADOW_SRAM_READ_ERR_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SHADOW_SRAM_WRITE_ERR_MASK (0x10000000U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SHADOW_SRAM_WRITE_ERR_SHIFT (28U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SHADOW_SRAM_WRITE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SHADOW_SRAM_WRITE_ERR_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SHADOW_SRAM_WRITE_ERR_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_FUSE_READ_ERR_MASK (0x20000000U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_FUSE_READ_ERR_SHIFT (29U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_FUSE_READ_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_FUSE_READ_ERR_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_FUSE_READ_ERR_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_FUSE_PROG_ERR_MASK (0x40000000U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_FUSE_PROG_ERR_SHIFT (30U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_FUSE_PROG_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_FUSE_PROG_ERR_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_FUSE_PROG_ERR_MASK)

#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SHADOW_NO_ACCESS_MASK (0x80000000U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SHADOW_NO_ACCESS_SHIFT (31U)
#define OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SHADOW_NO_ACCESS(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SHADOW_NO_ACCESS_SHIFT)) & OCOTP_HW_OCOTP_NONMASK_STATUS1_NONMASK_SHADOW_NO_ACCESS_MASK)
/*! @} */

/*! @name HW_OCOTP_MASK_CTRL1 - OTP Controller Mask Ctrl1 Register */
/*! @{ */

#define OCOTP_HW_OCOTP_MASK_CTRL1_TIMEOUT_COUNTER_MASK (0x7U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_TIMEOUT_COUNTER_SHIFT (0U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_TIMEOUT_COUNTER(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_TIMEOUT_COUNTER_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_TIMEOUT_COUNTER_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_TMEOUT_COUNTER_EN_MASK (0x8U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_TMEOUT_COUNTER_EN_SHIFT (3U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_TMEOUT_COUNTER_EN(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_TMEOUT_COUNTER_EN_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_TMEOUT_COUNTER_EN_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_PBRICK_ERR_MASK (0x20U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_PBRICK_ERR_SHIFT (5U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_PBRICK_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_PBRICK_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_PBRICK_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_OTP_STATE_ERR_MASK (0x40U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_OTP_STATE_ERR_SHIFT (6U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_OTP_STATE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_OTP_STATE_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_OTP_STATE_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_DED_RELOAD_MASK (0x80U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_DED_RELOAD_SHIFT (7U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_DED_RELOAD(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_DED_RELOAD_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_DED_RELOAD_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_DED_MASK (0x100U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_DED_SHIFT (8U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_DED(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_DED_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_DED_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SEC_RELOAD_MASK (0x200U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SEC_RELOAD_SHIFT (9U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SEC_RELOAD(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SEC_RELOAD_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SEC_RELOAD_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SEC_MASK (0x400U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SEC_SHIFT (10U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SEC(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SEC_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SEC_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_CRC_DONE_MASK (0x800U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_CRC_DONE_SHIFT (11U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_CRC_DONE(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_CRC_DONE_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_CRC_DONE_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_CRC_LUT_SEL_ERR_MASK (0x1000U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_CRC_LUT_SEL_ERR_SHIFT (12U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_CRC_LUT_SEL_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_CRC_LUT_SEL_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_CRC_LUT_SEL_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_CRC_ADDRESS_RANGE_ERR_MASK (0x2000U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_CRC_ADDRESS_RANGE_ERR_SHIFT (13U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_CRC_ADDRESS_RANGE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_CRC_ADDRESS_RANGE_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_CRC_ADDRESS_RANGE_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_CRC_WRITE_PROTECT_ERR_MASK (0x4000U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_CRC_WRITE_PROTECT_ERR_SHIFT (14U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_CRC_WRITE_PROTECT_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_CRC_WRITE_PROTECT_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_CRC_WRITE_PROTECT_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_CRC_SECURTY_PROTECT_ERR_MASK (0x8000U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_CRC_SECURTY_PROTECT_ERR_SHIFT (15U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_CRC_SECURTY_PROTECT_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_CRC_SECURTY_PROTECT_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_CRC_SECURTY_PROTECT_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_WRITE_ERR_MASK (0x10000U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_WRITE_ERR_SHIFT (16U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_WRITE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_WRITE_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_WRITE_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_LOAD_ERR_MASK (0x20000U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_LOAD_ERR_SHIFT (17U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_LOAD_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_LOAD_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_LOAD_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_COUNTER_ERR_MASK (0x40000U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_COUNTER_ERR_SHIFT (18U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_COUNTER_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_COUNTER_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_COUNTER_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_BITPROTECT_ERR_MASK (0x80000U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_BITPROTECT_ERR_SHIFT (19U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_BITPROTECT_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_BITPROTECT_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_BITPROTECT_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_PRNG_O_FAULT_MASK (0x100000U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_PRNG_O_FAULT_SHIFT (20U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_PRNG_O_FAULT(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_PRNG_O_FAULT_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_PRNG_O_FAULT_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_ECC_ZEROIZED_ERR_MASK (0x200000U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_ECC_ZEROIZED_ERR_SHIFT (21U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_ECC_ZEROIZED_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_ECC_ZEROIZED_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_ECC_ZEROIZED_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_FUSE_ACCESS_ERR_MASK (0x400000U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_FUSE_ACCESS_ERR_SHIFT (22U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_FUSE_ACCESS_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_FUSE_ACCESS_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_FUSE_ACCESS_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_RELOAD_REQ_ERR_MASK (0x800000U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_RELOAD_REQ_ERR_SHIFT (23U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_RELOAD_REQ_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_RELOAD_REQ_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_RELOAD_REQ_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_WRITE_DURING_RELOAD_ERR_MASK (0x1000000U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_WRITE_DURING_RELOAD_ERR_SHIFT (24U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_WRITE_DURING_RELOAD_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_WRITE_DURING_RELOAD_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_WRITE_DURING_RELOAD_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SHADOW_HVF_READ_ERR_MASK (0x2000000U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SHADOW_HVF_READ_ERR_SHIFT (25U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SHADOW_HVF_READ_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SHADOW_HVF_READ_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SHADOW_HVF_READ_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SHADOW_HVF_WRITE_ERR_MASK (0x4000000U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SHADOW_HVF_WRITE_ERR_SHIFT (26U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SHADOW_HVF_WRITE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SHADOW_HVF_WRITE_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SHADOW_HVF_WRITE_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SHADOW_SRAM_READ_ERR_MASK (0x8000000U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SHADOW_SRAM_READ_ERR_SHIFT (27U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SHADOW_SRAM_READ_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SHADOW_SRAM_READ_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SHADOW_SRAM_READ_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SHADOW_SRAM_WRITE_ERR_MASK (0x10000000U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SHADOW_SRAM_WRITE_ERR_SHIFT (28U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SHADOW_SRAM_WRITE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SHADOW_SRAM_WRITE_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SHADOW_SRAM_WRITE_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_FUSE_READ_ERR_MASK (0x20000000U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_FUSE_READ_ERR_SHIFT (29U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_FUSE_READ_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_FUSE_READ_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_FUSE_READ_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_FUSE_PROG_ERR_MASK (0x40000000U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_FUSE_PROG_ERR_SHIFT (30U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_FUSE_PROG_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_FUSE_PROG_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_FUSE_PROG_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SHADOW_NO_ACCESS_MASK (0x80000000U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SHADOW_NO_ACCESS_SHIFT (31U)
#define OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SHADOW_NO_ACCESS(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SHADOW_NO_ACCESS_SHIFT)) & OCOTP_HW_OCOTP_MASK_CTRL1_CTRL_MASK_SHADOW_NO_ACCESS_MASK)
/*! @} */

/*! @name HW_OCOTP_MASK_STATUS1 - OTP Controller Nonmask Status1 Register */
/*! @{ */

#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_PBRICK_ERR_MASK (0x20U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_PBRICK_ERR_SHIFT (5U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_PBRICK_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_MASK_PBRICK_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_MASK_PBRICK_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_OTP_STATE_ERR_MASK (0x40U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_OTP_STATE_ERR_SHIFT (6U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_OTP_STATE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_MASK_OTP_STATE_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_MASK_OTP_STATE_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_DED_RELOAD_MASK (0x80U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_DED_RELOAD_SHIFT (7U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_DED_RELOAD(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_DED_RELOAD_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_DED_RELOAD_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_DED_MASK (0x100U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_DED_SHIFT (8U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_DED(x)  (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_MASK_DED_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_MASK_DED_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_SEC_RELOAD_MASK (0x200U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_SEC_RELOAD_SHIFT (9U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_SEC_RELOAD(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_SEC_RELOAD_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_SEC_RELOAD_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SEC_MASK (0x400U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SEC_SHIFT (10U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SEC(x)  (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SEC_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SEC_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_CRC_DONE_MASK (0x800U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_CRC_DONE_SHIFT (11U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_CRC_DONE(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_MASK_CRC_DONE_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_MASK_CRC_DONE_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_CRC_LUT_SEL_ERR_MASK (0x1000U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_CRC_LUT_SEL_ERR_SHIFT (12U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_CRC_LUT_SEL_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_MASK_CRC_LUT_SEL_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_MASK_CRC_LUT_SEL_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_CRC_ADDRESS_RANGE_ERR_MASK (0x2000U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_CRC_ADDRESS_RANGE_ERR_SHIFT (13U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_CRC_ADDRESS_RANGE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_MASK_CRC_ADDRESS_RANGE_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_MASK_CRC_ADDRESS_RANGE_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_CRC_WRITE_PROTECT_ERR_MASK (0x4000U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_CRC_WRITE_PROTECT_ERR_SHIFT (14U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_CRC_WRITE_PROTECT_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_MASK_CRC_WRITE_PROTECT_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_MASK_CRC_WRITE_PROTECT_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_CRC_SECURTY_PROTECT_ERR_MASK (0x8000U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_CRC_SECURTY_PROTECT_ERR_SHIFT (15U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_CRC_SECURTY_PROTECT_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_MASK_CRC_SECURTY_PROTECT_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_MASK_CRC_SECURTY_PROTECT_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_WRITE_ERR_MASK (0x10000U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_WRITE_ERR_SHIFT (16U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_WRITE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_MASK_WRITE_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_MASK_WRITE_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_LOAD_ERR_MASK (0x20000U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_LOAD_ERR_SHIFT (17U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_LOAD_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_MASK_LOAD_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_MASK_LOAD_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_COUNTER_ERR_MASK (0x40000U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_COUNTER_ERR_SHIFT (18U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_COUNTER_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_MASK_COUNTER_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_MASK_COUNTER_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_BITPROTECT_ERR_MASK (0x80000U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_BITPROTECT_ERR_SHIFT (19U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_BITPROTECT_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_MASK_BITPROTECT_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_MASK_BITPROTECT_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_PRNG_O_FAULT_MASK (0x100000U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_PRNG_O_FAULT_SHIFT (20U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_PRNG_O_FAULT(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_MASK_PRNG_O_FAULT_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_MASK_PRNG_O_FAULT_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_ECC_ZEROIZED_ERR_MASK (0x200000U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_ECC_ZEROIZED_ERR_SHIFT (21U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_ECC_ZEROIZED_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_MASK_ECC_ZEROIZED_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_MASK_ECC_ZEROIZED_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_FUSE_ACCESS_ERR_MASK (0x400000U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_FUSE_ACCESS_ERR_SHIFT (22U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_FUSE_ACCESS_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_MASK_FUSE_ACCESS_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_MASK_FUSE_ACCESS_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_RELOAD_REQ_ERR_MASK (0x800000U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_RELOAD_REQ_ERR_SHIFT (23U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_RELOAD_REQ_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_MASK_RELOAD_REQ_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_MASK_RELOAD_REQ_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_WRITE_DURING_RELOAD_ERR_MASK (0x1000000U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_WRITE_DURING_RELOAD_ERR_SHIFT (24U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_WRITE_DURING_RELOAD_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_MASK_WRITE_DURING_RELOAD_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_MASK_WRITE_DURING_RELOAD_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SHADOW_HVF_READ_ERR_MASK (0x2000000U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SHADOW_HVF_READ_ERR_SHIFT (25U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SHADOW_HVF_READ_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SHADOW_HVF_READ_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SHADOW_HVF_READ_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SHADOW_HVF_WRITE_ERR_MASK (0x4000000U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SHADOW_HVF_WRITE_ERR_SHIFT (26U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SHADOW_HVF_WRITE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SHADOW_HVF_WRITE_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SHADOW_HVF_WRITE_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SHADOW_SRAM_READ_ERR_MASK (0x8000000U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SHADOW_SRAM_READ_ERR_SHIFT (27U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SHADOW_SRAM_READ_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SHADOW_SRAM_READ_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SHADOW_SRAM_READ_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SHADOW_SRAM_WRITE_ERR_MASK (0x10000000U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SHADOW_SRAM_WRITE_ERR_SHIFT (28U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SHADOW_SRAM_WRITE_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SHADOW_SRAM_WRITE_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SHADOW_SRAM_WRITE_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_FUSE_READ_ERR_MASK (0x20000000U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_FUSE_READ_ERR_SHIFT (29U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_FUSE_READ_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_MASK_FUSE_READ_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_MASK_FUSE_READ_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_FUSE_PROG_ERR_MASK (0x40000000U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_FUSE_PROG_ERR_SHIFT (30U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_FUSE_PROG_ERR(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_MASK_FUSE_PROG_ERR_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_MASK_FUSE_PROG_ERR_MASK)

#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SHADOW_NO_ACCESS_MASK (0x80000000U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SHADOW_NO_ACCESS_SHIFT (31U)
#define OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SHADOW_NO_ACCESS(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SHADOW_NO_ACCESS_SHIFT)) & OCOTP_HW_OCOTP_MASK_STATUS1_MASK_SHADOW_NO_ACCESS_MASK)
/*! @} */

/*! @name HW_OCOTP_LOCK_STICKY_0 - OTP Controller Lock Sticky Register0 */
/*! @{ */

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT0_MASK (0x1U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT0_SHIFT (0U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT0(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT0_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT0_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT1_MASK (0x2U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT1_SHIFT (1U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT1(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT1_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT1_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT2_MASK (0x4U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT2_SHIFT (2U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT2(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT2_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT2_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT3_MASK (0x8U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT3_SHIFT (3U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT3(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT3_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT3_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT4_MASK (0x10U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT4_SHIFT (4U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT4(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT4_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT4_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT5_MASK (0x20U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT5_SHIFT (5U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT5(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT5_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT5_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT6_MASK (0x40U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT6_SHIFT (6U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT6(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT6_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT6_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT7_MASK (0x80U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT7_SHIFT (7U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT7(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT7_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT7_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT8_MASK (0x100U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT8_SHIFT (8U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT8(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT8_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT8_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT9_MASK (0x200U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT9_SHIFT (9U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT9(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT9_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT9_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT10_MASK (0x400U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT10_SHIFT (10U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT10(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT10_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT10_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT11_MASK (0x800U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT11_SHIFT (11U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT11(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT11_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT11_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT12_MASK (0x1000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT12_SHIFT (12U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT12(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT12_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT12_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT13_MASK (0x2000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT13_SHIFT (13U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT13(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT13_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT13_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT14_MASK (0x4000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT14_SHIFT (14U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT14(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT14_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT14_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT15_MASK (0x8000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT15_SHIFT (15U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT15(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT15_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT15_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT16_MASK (0x10000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT16_SHIFT (16U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT16(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT16_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT16_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT17_MASK (0x20000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT17_SHIFT (17U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT17(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT17_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT17_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT18_MASK (0x40000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT18_SHIFT (18U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT18(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT18_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT18_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT19_MASK (0x80000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT19_SHIFT (19U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT19(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT19_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT19_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT20_MASK (0x100000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT20_SHIFT (20U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT20(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT20_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT20_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT21_MASK (0x200000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT21_SHIFT (21U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT21(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT21_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT21_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT22_MASK (0x400000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT22_SHIFT (22U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT22(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT22_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT22_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT23_MASK (0x800000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT23_SHIFT (23U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT23(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT23_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT23_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT24_MASK (0x1000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT24_SHIFT (24U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT24(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT24_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT24_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT25_MASK (0x2000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT25_SHIFT (25U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT25(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT25_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT25_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT26_MASK (0x4000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT26_SHIFT (26U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT26(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT26_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT26_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT27_MASK (0x8000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT27_SHIFT (27U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT27(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT27_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT27_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT28_MASK (0x10000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT28_SHIFT (28U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT28(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT28_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT28_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT29_MASK (0x20000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT29_SHIFT (29U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT29(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT29_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT29_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT30_MASK (0x40000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT30_SHIFT (30U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT30(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT30_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT30_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT31_MASK (0x80000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT31_SHIFT (31U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT31(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT31_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_0_LOCK_STICKY_BIT31_MASK)
/*! @} */

/*! @name HW_OCOTP_LOCK_STICKY_1 - OTP Controller Lock Sticky Register1 */
/*! @{ */

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT32_MASK (0x1U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT32_SHIFT (0U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT32(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT32_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT32_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT33_MASK (0x2U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT33_SHIFT (1U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT33(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT33_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT33_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT34_MASK (0x4U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT34_SHIFT (2U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT34(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT34_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT34_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT35_MASK (0x8U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT35_SHIFT (3U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT35(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT35_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT35_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT36_MASK (0x10U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT36_SHIFT (4U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT36(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT36_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT36_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT37_MASK (0x20U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT37_SHIFT (5U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT37(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT37_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT37_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT38_MASK (0x40U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT38_SHIFT (6U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT38(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT38_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT38_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT39_MASK (0x80U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT39_SHIFT (7U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT39(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT39_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT39_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT40_MASK (0x100U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT40_SHIFT (8U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT40(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT40_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT40_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT41_MASK (0x200U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT41_SHIFT (9U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT41(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT41_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT41_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT42_MASK (0x400U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT42_SHIFT (10U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT42(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT42_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT42_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT43_MASK (0x800U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT43_SHIFT (11U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT43(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT43_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT43_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT44_MASK (0x1000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT44_SHIFT (12U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT44(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT44_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT44_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT45_MASK (0x2000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT45_SHIFT (13U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT45(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT45_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT45_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT46_MASK (0x4000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT46_SHIFT (14U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT46(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT46_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT46_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT47_MASK (0x8000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT47_SHIFT (15U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT47(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT47_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT47_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT48_MASK (0x10000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT48_SHIFT (16U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT48(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT48_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT48_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT49_MASK (0x20000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT49_SHIFT (17U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT49(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT49_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT49_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT50_MASK (0x40000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT50_SHIFT (18U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT50(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT50_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT50_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT51_MASK (0x80000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT51_SHIFT (19U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT51(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT51_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT51_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT52_MASK (0x100000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT52_SHIFT (20U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT52(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT52_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT52_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT53_MASK (0x200000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT53_SHIFT (21U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT53(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT53_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT53_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT54_MASK (0x400000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT54_SHIFT (22U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT54(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT54_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT54_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT55_MASK (0x800000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT55_SHIFT (23U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT55(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT55_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT55_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT56_MASK (0x1000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT56_SHIFT (24U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT56(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT56_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT56_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT57_MASK (0x2000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT57_SHIFT (25U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT57(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT57_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT57_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT58_MASK (0x4000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT58_SHIFT (26U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT58(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT58_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT58_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT59_MASK (0x8000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT59_SHIFT (27U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT59(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT59_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT59_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT60_MASK (0x10000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT60_SHIFT (28U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT60(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT60_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT60_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT61_MASK (0x20000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT61_SHIFT (29U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT61(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT61_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT61_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT62_MASK (0x40000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT62_SHIFT (30U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT62(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT62_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT62_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT63_MASK (0x80000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT63_SHIFT (31U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT63(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT63_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_1_LOCK_STICKY_BIT63_MASK)
/*! @} */

/*! @name HW_OCOTP_LOCK_STICKY_2 - OTP Controller Lock Sticky Register2 */
/*! @{ */

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT64_MASK (0x1U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT64_SHIFT (0U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT64(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT64_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT64_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT65_MASK (0x2U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT65_SHIFT (1U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT65(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT65_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT65_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT66_MASK (0x4U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT66_SHIFT (2U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT66(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT66_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT66_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT67_MASK (0x8U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT67_SHIFT (3U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT67(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT67_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT67_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT68_MASK (0x10U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT68_SHIFT (4U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT68(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT68_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT68_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT69_MASK (0x20U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT69_SHIFT (5U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT69(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT69_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT69_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT70_MASK (0x40U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT70_SHIFT (6U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT70(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT70_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT70_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT71_MASK (0x80U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT71_SHIFT (7U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT71(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT71_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT71_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT72_MASK (0x100U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT72_SHIFT (8U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT72(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT72_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT72_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT73_MASK (0x200U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT73_SHIFT (9U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT73(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT73_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT73_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT74_MASK (0x400U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT74_SHIFT (10U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT74(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT74_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT74_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT75_MASK (0x800U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT75_SHIFT (11U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT75(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT75_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT75_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT76_MASK (0x1000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT76_SHIFT (12U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT76(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT76_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT76_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT77_MASK (0x2000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT77_SHIFT (13U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT77(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT77_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT77_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT78_MASK (0x4000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT78_SHIFT (14U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT78(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT78_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT78_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT79_MASK (0x8000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT79_SHIFT (15U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT79(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT79_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT79_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT80_MASK (0x10000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT80_SHIFT (16U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT80(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT80_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT80_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT81_MASK (0x20000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT81_SHIFT (17U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT81(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT81_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT81_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT82_MASK (0x40000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT82_SHIFT (18U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT82(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT82_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT82_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT83_MASK (0x80000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT83_SHIFT (19U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT83(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT83_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT83_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT84_MASK (0x100000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT84_SHIFT (20U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT84(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT84_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT84_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT85_MASK (0x200000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT85_SHIFT (21U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT85(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT85_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT85_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT86_MASK (0x400000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT86_SHIFT (22U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT86(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT86_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT86_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT87_MASK (0x800000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT87_SHIFT (23U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT87(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT87_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT87_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT88_MASK (0x1000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT88_SHIFT (24U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT88(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT88_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT88_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT89_MASK (0x2000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT89_SHIFT (25U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT89(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT89_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT89_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT90_MASK (0x4000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT90_SHIFT (26U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT90(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT90_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT90_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT91_MASK (0x8000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT91_SHIFT (27U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT91(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT91_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT91_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT92_MASK (0x10000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT92_SHIFT (28U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT92(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT92_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT92_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT93_MASK (0x20000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT93_SHIFT (29U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT93(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT93_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT93_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT94_MASK (0x40000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT94_SHIFT (30U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT94(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT94_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT94_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT95_MASK (0x80000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT95_SHIFT (31U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT95(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT95_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_2_LOCK_STICKY_BIT95_MASK)
/*! @} */

/*! @name HW_OCOTP_LOCK_STICKY_3 - OTP Controller Lock Sticky Register3 */
/*! @{ */

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT96_MASK (0x1U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT96_SHIFT (0U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT96(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT96_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT96_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT97_MASK (0x2U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT97_SHIFT (1U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT97(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT97_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT97_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT98_MASK (0x4U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT98_SHIFT (2U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT98(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT98_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT98_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT99_MASK (0x8U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT99_SHIFT (3U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT99(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT99_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT99_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT100_MASK (0x10U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT100_SHIFT (4U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT100(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT100_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT100_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT101_MASK (0x20U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT101_SHIFT (5U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT101(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT101_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT101_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT102_MASK (0x40U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT102_SHIFT (6U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT102(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT102_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT102_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT103_MASK (0x80U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT103_SHIFT (7U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT103(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT103_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT103_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT104_MASK (0x100U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT104_SHIFT (8U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT104(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT104_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT104_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT105_MASK (0x200U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT105_SHIFT (9U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT105(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT105_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT105_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT106_MASK (0x400U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT106_SHIFT (10U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT106(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT106_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT106_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT107_MASK (0x800U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT107_SHIFT (11U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT107(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT107_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT107_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT108_MASK (0x1000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT108_SHIFT (12U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT108(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT108_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT108_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT109_MASK (0x2000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT109_SHIFT (13U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT109(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT109_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT109_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT110_MASK (0x4000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT110_SHIFT (14U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT110(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT110_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT110_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT111_MASK (0x8000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT111_SHIFT (15U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT111(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT111_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT111_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT112_MASK (0x10000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT112_SHIFT (16U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT112(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT112_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT112_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT113_MASK (0x20000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT113_SHIFT (17U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT113(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT113_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT113_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT114_MASK (0x40000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT114_SHIFT (18U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT114(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT114_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT114_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT115_MASK (0x80000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT115_SHIFT (19U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT115(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT115_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT115_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT116_MASK (0x100000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT116_SHIFT (20U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT116(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT116_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT116_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT117_MASK (0x200000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT117_SHIFT (21U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT117(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT117_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT117_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT118_MASK (0x400000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT118_SHIFT (22U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT118(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT118_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT118_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT119_MASK (0x800000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT119_SHIFT (23U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT119(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT119_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT119_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT120_MASK (0x1000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT120_SHIFT (24U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT120(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT120_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT120_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT121_MASK (0x2000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT121_SHIFT (25U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT121(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT121_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT121_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT122_MASK (0x4000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT122_SHIFT (26U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT122(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT122_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT122_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT123_MASK (0x8000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT123_SHIFT (27U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT123(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT123_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT123_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT124_MASK (0x10000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT124_SHIFT (28U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT124(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT124_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT124_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT125_MASK (0x20000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT125_SHIFT (29U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT125(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT125_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT125_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT126_MASK (0x40000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT126_SHIFT (30U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT126(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT126_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT126_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT127_MASK (0x80000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT127_SHIFT (31U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT127(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT127_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_3_LOCK_STICKY_BIT127_MASK)
/*! @} */

/*! @name HW_OCOTP_LOCK_STICKY_4 - OTP Controller Lock Sticky Register4 */
/*! @{ */

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT128_MASK (0x1U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT128_SHIFT (0U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT128(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT128_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT128_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT129_MASK (0x2U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT129_SHIFT (1U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT129(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT129_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT129_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT130_MASK (0x4U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT130_SHIFT (2U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT130(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT130_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT130_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT131_MASK (0x8U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT131_SHIFT (3U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT131(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT131_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT131_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT132_MASK (0x10U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT132_SHIFT (4U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT132(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT132_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT132_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT133_MASK (0x20U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT133_SHIFT (5U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT133(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT133_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT133_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT134_MASK (0x40U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT134_SHIFT (6U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT134(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT134_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT134_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT135_MASK (0x80U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT135_SHIFT (7U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT135(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT135_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT135_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT136_MASK (0x100U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT136_SHIFT (8U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT136(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT136_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT136_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT137_MASK (0x200U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT137_SHIFT (9U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT137(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT137_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT137_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT138_MASK (0x400U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT138_SHIFT (10U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT138(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT138_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT138_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT139_MASK (0x800U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT139_SHIFT (11U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT139(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT139_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT139_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT140_MASK (0x1000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT140_SHIFT (12U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT140(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT140_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT140_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT141_MASK (0x2000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT141_SHIFT (13U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT141(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT141_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT141_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT142_MASK (0x4000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT142_SHIFT (14U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT142(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT142_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT142_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT143_MASK (0x8000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT143_SHIFT (15U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT143(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT143_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT143_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT144_MASK (0x10000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT144_SHIFT (16U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT144(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT144_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT144_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT145_MASK (0x20000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT145_SHIFT (17U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT145(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT145_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT145_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT146_MASK (0x40000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT146_SHIFT (18U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT146(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT146_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT146_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT147_MASK (0x80000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT147_SHIFT (19U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT147(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT147_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT147_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT148_MASK (0x100000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT148_SHIFT (20U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT148(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT148_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT148_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT149_MASK (0x200000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT149_SHIFT (21U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT149(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT149_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT149_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT150_MASK (0x400000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT150_SHIFT (22U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT150(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT150_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT150_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT151_MASK (0x800000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT151_SHIFT (23U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT151(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT151_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT151_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT152_MASK (0x1000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT152_SHIFT (24U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT152(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT152_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT152_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT153_MASK (0x2000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT153_SHIFT (25U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT153(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT153_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT153_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT154_MASK (0x4000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT154_SHIFT (26U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT154(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT154_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT154_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT155_MASK (0x8000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT155_SHIFT (27U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT155(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT155_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT155_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT156_MASK (0x10000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT156_SHIFT (28U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT156(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT156_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT156_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT157_MASK (0x20000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT157_SHIFT (29U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT157(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT157_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT157_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT158_MASK (0x40000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT158_SHIFT (30U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT158(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT158_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT158_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT159_MASK (0x80000000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT159_SHIFT (31U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT159(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT159_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_4_LOCK_STICKY_BIT159_MASK)
/*! @} */

/*! @name HW_OCOTP_LOCK_STICKY_5 - OTP Controller Lock Sticky Register5 */
/*! @{ */

#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT160_MASK (0x1U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT160_SHIFT (0U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT160(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT160_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT160_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT161_MASK (0x2U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT161_SHIFT (1U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT161(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT161_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT161_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT162_MASK (0x4U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT162_SHIFT (2U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT162(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT162_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT162_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT163_MASK (0x8U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT163_SHIFT (3U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT163(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT163_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT163_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT164_MASK (0x10U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT164_SHIFT (4U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT164(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT164_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT164_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT165_MASK (0x20U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT165_SHIFT (5U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT165(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT165_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT165_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT166_MASK (0x40U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT166_SHIFT (6U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT166(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT166_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT166_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT167_MASK (0x80U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT167_SHIFT (7U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT167(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT167_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT167_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT168_MASK (0x100U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT168_SHIFT (8U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT168(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT168_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT168_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT169_MASK (0x200U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT169_SHIFT (9U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT169(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT169_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT169_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT170_MASK (0x400U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT170_SHIFT (10U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT170(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT170_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT170_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT171_MASK (0x800U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT171_SHIFT (11U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT171(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT171_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT171_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT172_MASK (0x1000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT172_SHIFT (12U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT172(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT172_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT172_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT173_MASK (0x2000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT173_SHIFT (13U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT173(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT173_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT173_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT174_MASK (0x4000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT174_SHIFT (14U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT174(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT174_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT174_MASK)

#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT175_MASK (0x8000U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT175_SHIFT (15U)
#define OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT175(x) (((uint32_t)(((uint32_t)(x)) << OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT175_SHIFT)) & OCOTP_HW_OCOTP_LOCK_STICKY_5_LOCK_STICKY_BIT175_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group OCOTP_Register_Masks */


/*!
 * @}
 */ /* end of group OCOTP_Peripheral_Access_Layer */


/*
** End of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic pop
  #else
    #pragma pop
  #endif
#elif defined(__GNUC__)
  /* leave anonymous unions enabled */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=default
#elif defined(__XTENSA__)
  /* leave anonymous unions enabled */
#else
  #error Not supported compiler type
#endif

/*!
 * @}
 */ /* end of group Peripheral_access_layer */


#endif  /* OCOTP_H_ */

